﻿var LicenseManagementController = {

    callServer: function(method, params, onSuccess)
    {
        $.ajax({
            url: '/LicenseManagement/' + method,
            type: 'POST',
            dataType: 'json',
            data: JSON.stringify(params),
            async: true,
            cache: false,
            traditional: true,
            contentType: 'application/json',
            success: onSuccess,
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                alert(errorThrown);
                return false;
            }
        });
    },

    GetLicenses: function (onSuccess) {
        this.callServer('GetLicenses', {}, onSuccess);
    },

    VerifyLicenses: function (licenseName, keys, onSuccess) {
        this.callServer('VerifyLicenses', { licenseName: licenseName, keys: keys }, onSuccess);
    },

    AddLicense: function (licenseName, key, onSuccess) {
        this.callServer('AddLicense', { licenseName: licenseName, key: key }, onSuccess);
    },

    RemoveLicense: function (licenseName, key, onSuccess) {
        this.callServer('RemoveLicense', { licenseName: licenseName, key: key }, onSuccess);
    },

    ReleaseLicense: function (licenseName, key, onSuccess) {
        this.callServer('ReleaseLicense', { licenseName: licenseName, key: key }, onSuccess);
    },
}